﻿

CREATE PROCEDURE [App].[NVCC_usp_GetSensDx]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetSensDx
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-20-2016
--
--Changed               : 01-20-2016
--Changed By            : Jerry Kohler
--Reason For Change     : Removed station parameter; we want the data for the
--                        patient no matter where that patient was treated.
--
--Changed               : 01-29-2016
--Changed By            : Jerry Kohler
--Reason For Change     : Consolidated some queries the script was doing into fewer,
--                        smaller ones since we now have a table containing all of
--                        the sensitive diagnoses & ICD SIDS (9 & 10)
--
--Purpose               : Retrieve any sensitive diagnoses that may exist for a
--                        patient.  If there are any, they require special handling
--                        to determine which outsource partners can know about them.
--==================================================================================
AS

BEGIN
    -- declare @pid bigint; set @pid=1717444;
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    DECLARE @flag int;
    SET @flag=0;

    -- Check all of a patient's recorded diagnoses against our table of sensitive
    -- diagnoses, and record the various diagnosis flags.
    SELECT --TOP 3000 
		CASE
			WHEN p.ICD10SID > 0 THEN p.ICD10SID
			ELSE p.ICD9SID
		END as Code
		,CASE
			WHEN p.ICD10SID > 0 THEN 'ICD10'
			ELSE 'ICD9'
		END as  CodingSystem
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.AbuseDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.AbuseDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as AbuseDx
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.SickleDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.SickleDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as SickleDx
		,CASE
			WHEN p.ICD10SID > 0 THEN 
				(select top 1 s.HIVDx from App.NVCC_SensitiveDxCodes s where p.ICD10SID = s.ICDSID)
			ELSE
				(select top 1 t.HIVDx from App.NVCC_SensitiveDxCodes t where p.ICD9SID = t.ICDSID)
		END as HIVDx
     INTO #ptsdx
     FROM CDWWork.Outpat.VDiagnosis p
     JOIN App.NVCC_SensitiveDxCodes x on (p.ICD9SID = x.ICDSID OR p.ICD10SID = x.ICDSID)
     WHERE PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid));


          
     IF ((select sum(AbuseDx) from #ptsdx) > 0)  set @flag=@flag+1;
     IF ((select sum(HIVDx) from #ptsdx) > 0)    set @flag=@flag+4;
     IF ((select sum(SickleDx) from #ptsdx) > 0) set @flag=@flag+16;


     -- Check all of a patient's recorded ICD codes recorded on his problem list
     -- against our table of sensitive diagnoses, and record the various
     -- diagnosis flags.
     SELECT prb.ICD9SID
           ,prb.ICD10SID
           ,prb.PatientSID
           ,x.AbuseDx
           ,x.SickleDx
           ,x.HIVDx 
     INTO #ptsprb
     FROM CDWWork.Outpat.ProblemList AS prb 
     INNER JOIN App.NVCC_SensitiveDxCodes x on (prb.ICD9SID = x.ICDSID OR prb.ICD10SID = x.ICDSID)
     WHERE PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid))
       AND prb.ActiveFlag = 'A'
       AND prb.ProblemListCondition <> 'H';

     if ((select sum(AbuseDx) from #ptsprb) > 0) set @flag=@flag+2;
     if ((select sum(HIVDx) from #ptsprb)   > 0) set @flag=@flag+8;
     if ((select sum(SickleDx) from #ptsprb)> 0) set @flag=@flag+32;


     drop table #ptsdx;
     drop table #ptsprb;

     select @flag as sensdxflag;
     --exec [App].[NVCC_usp_GetSensDx] @pid=1717444;
     end;



